/*
Cria os objetos usados na demo do RG
*/

USE MASTER
GO

-- Cria o Pool Pool_RH_Adhoc com valores default 100% CPU
IF NOT EXISTS (SELECT name FROM sys.resource_governor_resource_pools WHERE name = 'Pool_RH_Adhoc')
	CREATE RESOURCE POOL [Pool_RH_Adhoc]

-- Cria o Pool Pool_Online com parmetros default 100% CPU
IF NOT EXISTS (SELECT name FROM sys.resource_governor_resource_pools WHERE name = 'Pool_Online')
	CREATE RESOURCE POOL [Pool_Online] 

-- Os processos de admin ficaro no pool default

-- Cria o Gropo GAdhoc e o associa ao Pool [Pool_RH_Adhoc]
IF NOT EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GAdhoc')
	CREATE WORKLOAD GROUP [GAdhoc] USING [Pool_RH_Adhoc]

-- Cria o Gropo GRH e o associa ao Pool [Pool_RH_Adhoc]
IF NOT EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GRH')
	CREATE WORKLOAD GROUP [GRH] USING [Pool_RH_Adhoc]

-- Cria o Gropo GOnline e o associa ao Pool [Pool_Online]
IF NOT EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GOnline')
	CREATE WORKLOAD GROUP [GOnline] USING [Pool_Online]
	/*
	WITH(group_max_requests=0, 
		importance=Low, 
		request_max_cpu_time_sec=0, 
		request_max_memory_grant_percent=25, 
		request_memory_grant_timeout_sec=0, 
		max_dop=0)
	USING [Pool_Online]
	*/	
GO

IF (SELECT 1 FROM sys.objects WHERE name=('fn_Classifica_Apps'))=1
BEGIN
	ALTER RESOURCE GOVERNOR WITH (CLASSIFIER_FUNCTION = NULL) 
	ALTER RESOURCE GOVERNOR RECONFIGURE;
	DROP FUNCTION dbo.fn_Classifica_Apps
END
GO

-- Cria a UDF que agrupar as aplicaes sobre o grupo de 
-- forma que os limites de consumo de recurso sejam aplicados
CREATE FUNCTION dbo.fn_Classifica_Apps()
RETURNS SYSNAME WITH SCHEMABINDING 
AS 
BEGIN
  DECLARE @ret sysname  
  SET @ret = 'default'

  IF (ORIGINAL_DB_NAME()='AdventureWorksDW2008')
	 SET @ret='GAdhoc' -- Case-sensitive
  ELSE IF (ORIGINAL_DB_NAME()='AdventureWorks')
	 SET @ret='GRH' -- Case-sensitive
  ELSE IF (ORIGINAL_DB_NAME()='AdventureWorks2008')
	 SET @ret='GOnline' -- Case-sensitive

  RETURN @ret 
END

GO
ALTER RESOURCE GOVERNOR WITH (CLASSIFIER_FUNCTION = dbo.fn_Classifica_Apps) 
ALTER RESOURCE GOVERNOR RECONFIGURE

--	ALTER RESOURCE GOVERNOR WITH (CLASSIFIER_FUNCTION = NULL) 
--	ALTER RESOURCE GOVERNOR RECONFIGURE;
