/*
Remove os objetos usados na demo do RG
*/

USE master
GO

ALTER RESOURCE POOL [Default] 
WITH(max_cpu_percent=100)

-- Efetiva a alterao do Pool
ALTER RESOURCE GOVERNOR RECONFIGURE

IF EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GAdhoc')
	DROP WORKLOAD GROUP [GAdhoc] 

IF EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GRH')
	DROP WORKLOAD GROUP [GRH]

IF EXISTS (SELECT name FROM sys.resource_governor_workload_groups WHERE name = 'GOnline')
	DROP WORKLOAD GROUP [GOnline]

IF EXISTS (SELECT name FROM sys.resource_governor_resource_pools WHERE name = 'Pool_RH_Adhoc')
	DROP RESOURCE POOL [Pool_RH_Adhoc] 

IF EXISTS (SELECT name FROM sys.resource_governor_resource_pools WHERE name = 'Pool_Online')
	DROP RESOURCE POOL [Pool_Online] 

-- Desvincula a funo do RG
IF (SELECT classifier_function_id FROM sys.resource_governor_configuration)>0
	ALTER RESOURCE GOVERNOR WITH (CLASSIFIER_FUNCTION = NULL) 
	ALTER RESOURCE GOVERNOR RECONFIGURE;
	
IF (SELECT OBJECT_ID('dbo.fn_Classifica_Apps'))>0
	DROP FUNCTION dbo.fn_Classifica_Apps

-- Desativa o RG caso esteja ativo
IF (SELECT is_enabled FROM  sys.resource_governor_configuration)=1
	ALTER RESOURCE GOVERNOR DISABLE;
GO

/*
select * from sys.all_sql_modules 
WHERE [OBJECT_ID]=OBJECT_ID('fn_Classifica_Apps')

*/